<?php

class CIRender {

	private $class;
	private $iid;
	private $m_tt = false;
	private $m_im = false;
	private $m_cn = false;
	private $m_vd = false;
	
	private function XWPCreatePoster() {
		$dir = plugin_dir_path(__FILE__) . 'Render';
		if(stripos($this->m_im, "http") !== false) {
			$url = $this->m_im;
		} else {
			$url = "https://tse1.mm.bing.net/th?id={$this->m_im}&w=360";
		}
		$sav = $dir . "/image/{$this->iid}.png";
		$std = $dir . "/image/poster.png";
		$ch = curl_init($url);
		$fp = fopen($sav, 'wb');
		curl_setopt($ch, CURLOPT_FILE, $fp);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); 
		curl_setopt($ch, CURLOPT_FAILONERROR, true);
		$result = curl_exec($ch);
		if (getimagesize($sav) === false) {
			copy($std, $sav);
		}
		curl_close($ch);
		fclose($fp);
	}
	
	public function __construct($class, $iid = false) {
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$this->class = $class;
		if($iid === false) {
			if($this->class == "movie") {
				if(mt_rand(0, 1)) {
					$base = @file_get_contents($dir . "/c-movie/imdb_T.dat");
				} else {
					$base = @file_get_contents($dir . "/c-movie/imdb_L.dat");
				}
				if(strlen($base) < 8) {
					$base = @file_get_contents($dir . "/c-movie/imdb.dat");
				}
			}
			if($this->class == "softw") {
				$base = file_get_contents($dir . "/c-softw/soft.dat");
			}
			$base = explode("\r\n~\r\n", $base);
			$mdat = $base[array_rand($base)];
			$mdat = explode("\r\n", $mdat);
			$this->iid = substr(md5($mdat[0]),-6);
			$this->m_tt = $mdat[0];
			$this->m_im = $mdat[1];
			$this->m_cn = $mdat[2];
			$this->m_vd = $mdat[3];
			$this->XWPCreatePoster();
		}
		else {
			$this->iid = $iid;
		}
	}
	
	private function _setSiteAddiction($seed = "") {
		srand(hexdec(substr(md5(site_url().$seed), -5)));
	}
	
	private function _setTimeAddiction() {
		srand(round(microtime(true) * 1000) + mt_rand(0,10**6));
	}
	
	private function XWPRenderImage() {
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$image = @imagecreatefromjpeg($dir . "/image/{$this->iid}.png");
		$width = imagesx($image);
		$height = imagesy($image);
		$scFactor = 1 + (mt_rand(-5, 5) / 100);
		$scWidth = (int)($width * $scFactor);
		$scHeight = (int)($height * $scFactor);
		$resized = imagecreatetruecolor($scWidth, $scHeight);
		imagealphablending($resized, false);
		imagesavealpha($resized, true);
		imagecopyresampled(
			$resized, $image,
			0, 0, 0, 0,
			$scWidth, $scHeight,
			$width, $height
		);
		$crLeft = mt_rand(0, 10);
		$crTop = mt_rand(0, 10);
		$cropRight = mt_rand(0, 10);
		$cropBottom = mt_rand(0, 10);
		$crWidth = $scWidth - $crLeft - $cropRight;
		$crHeight = $scHeight - $crTop - $cropBottom;
		$cropped = imagecreatetruecolor($crWidth, $crHeight);
		imagealphablending($cropped, false);
		imagesavealpha($cropped, true);
		imagecopy(
			$cropped, $resized,
			0, 0, $crLeft, $crTop,
			$crWidth, $crHeight
		);
		ob_start();
		imagepng($cropped);
		$imgData = ob_get_clean();
		imagedestroy($image);
		imagedestroy($resized);
		imagedestroy($cropped);
		return 'data:image/png;base64,' . base64_encode($imgData);
	}

	private function XWPRenderObject($object, $wrap = false) {
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$base = file_get_contents($dir . "/$object.dat");
		$base = explode("\r\n~\r\n", $base);
		$text = "";
		$index = 0;
		foreach($base as $block) {
			$index++;
			$a_blk = explode("\r\n", $block);
			$r_pre = "";
			while($r_pre == "") {
				$r_pre = trim($a_blk[array_rand($a_blk)]);
			}
			$text .= $r_pre . " ";
		}
		if($wrap) {
			$text = str_replace("%WRAP%", $wrap, $text);
		}
		return trim($text);
	}

	public function XWPRenderCategory($cposts) {
		$this->_setSiteAddiction(intval($cposts / XWP_POSTING_CAT));
		if($this->class == "movie") {
			return $this->XWPRenderObject("sh_categ_movie");
		}
		if($this->class == "softw") {
			return $this->XWPRenderObject("sh_categ_softw");
		}
	}

	public function XWPRenderPTitle() {
		$this->_setTimeAddiction();
		$dir = plugin_dir_path(__FILE__) . 'Render';
		if($this->class == "movie") {
			$base = file_get_contents($dir . "/sh_ptitle_movie.dat");
		}
		if($this->class == "softw") {
			$base = file_get_contents($dir . "/sh_ptitle_softw.dat");
		}
		$base = explode("\r\n", $base);
		$title =  $this->m_tt . " ";
		foreach($base as $block) {
			$t_a = explode(",", $block);
			$title .= trim($t_a[array_rand($t_a)]) . " ";
		}
		$title = str_replace("{}", "", $title);
		for($n = 0; $n < 5; $n++) {
			$title = str_replace("  ", " ", $title);
		}
		return trim($title);
	}

	public function XWPRenderPContent() {
		$this->_setTimeAddiction();
		$title = $this->m_tt;
		$content = $this->m_cn;
		$video = $this->m_vd;
		$opt_n = mt_rand(2, 4);
		$optimiz = "";
		for($n = 0; $n < $opt_n; $n++) {
			if($this->class == "movie") {
				$li_tag = $this->XWPRenderObject("sh_optim_movie");
			}
			if($this->class == "softw") {
				$li_tag = $this->XWPRenderObject("sh_optim_softw");
			}
			$li_tag = str_replace("%ITEM%", $title, $li_tag);
			$optimiz .= $li_tag;
		}
		$optimiz = $this->XWPRenderObject("wr_ulol", $optimiz);
		$content .= $optimiz;
		if(mt_rand(0, 1)) {
			$videofr = $this->XWPRenderObject("wr_video", $video);
			$content .= $videofr;
		}
		return $content;
	}

	public function XWPRenderLnkBlock() {
		$this->_setSiteAddiction();
		$dir = plugin_dir_path(__FILE__) . 'Render';
		$dtable = $this->XWPRenderObject("sh_dtable");
		$dbutts = $this->XWPRenderObject("sh_button");
		$this->_setTimeAddiction();
		$sizegb = $this->XWPRenderObject("sh_sizegb");
		if($this->class == "movie") {
			$drequm = $this->XWPRenderObject("sh_dreqm_movie");
		}
		if($this->class == "softw") {
			$drequm = $this->XWPRenderObject("sh_dreqm_softw");
		}
		$drequm = $this->XWPRenderObject("wr_dreqm_ul", $drequm);
		$block = $sizegb . $dbutts . $drequm;
		$block = $this->XWPRenderObject("wr_dreqm_dv", $block);
		$image = $this->XWPRenderImage();
		$dtable = str_replace("%IMAGE%", $image, $dtable);
		$dtable = str_replace("%BUTTS%", $block, $dtable);
		return $dtable;
	}

	public function XWPRenderDownPage($title) {
		$this->_setSiteAddiction();
		$dir = plugin_dir_path(__FILE__) . 'Render';
		if (!is_dir($dir . "/dpage")) {
			return false;
		}
		$files = glob($dir . '/dpage/*.*');
		if (empty($files)) {
			return false;
		}
		$dpage = $files[array_rand($files)];
		$dhtml = file_get_contents($dpage);
		$dcont = $this->XWPRenderObject("sh_dpage");
		$dcont = $this->XWPRenderObject("wr_dpage", $dcont);
		if($this->class == "movie") {
			$b_file = $dir . "/[movie].html";
		}
		if($this->class == "softw") {
			$b_file = $dir . "/[softw].html";
		}
		$b_html = file_get_contents($b_file);
		$image = $this->XWPRenderImage();
		$b_html = str_replace("%IMAGE%", $image, $b_html);
		$dhtml = str_replace("%DTITLE%", $title, $dhtml);
		$dhtml = str_replace("%DBLOCK%", $b_html, $dhtml);
		$dhtml = str_replace("%DCONTS%", $dcont, $dhtml);
		return $dhtml;
	}
}

?>